from django.core.management.base import BaseCommand
from django.utils import timezone
from subscription.models import (
    AnnualSubscription,
    SubjectBasedSubscription,
    BundleSubscription
)
from subscription.views import send_expiry_notification

class Command(BaseCommand):
    help = 'Sends notifications for expiring subscriptions'

    def handle(self, *args, **options):
        today = timezone.now().date()
        
        # Check subscriptions expiring in 7 days
        expiry_date = today + timezone.timedelta(days=7)
        
        annual_subs = AnnualSubscription.objects.filter(
            end_date=expiry_date,
            is_active=True
        )
        
        # For subject/bundle subscriptions, check Dec 24 to notify for Dec 31 expiry
        if today.month == 12 and today.day == 24:
            subject_subs = SubjectBasedSubscription.objects.filter(
                end_date__year=today.year,
                is_active=True
            )
            bundle_subs = BundleSubscription.objects.filter(
                end_date__year=today.year,
                is_active=True
            )
        else:
            subject_subs = SubjectBasedSubscription.objects.none()
            bundle_subs = BundleSubscription.objects.none()
        
        # Send notifications
        for sub in list(annual_subs) + list(subject_subs) + list(bundle_subs):
            send_expiry_notification(sub)
            self.stdout.write(f"Sent expiry notice to {sub.student.user.email}")