from pathlib import Path
import os


BASE_DIR = Path(__file__).resolve().parent.parent


# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/5.2/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = os.environ.get('DJANGO_SECRET_KEY', 'django-insecure-(3f$as2nbq=+jt)2l)+9*#nk(!)u_bksr*0j5uy9&6-l3ibot!')

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = os.environ.get('DJANGO_DEBUG', 'True') == 'True'


ALLOWED_HOSTS = [
    "passmcq.com",
    "www.passmcq.com",
    "127.0.0.1",
    "localhost",
    "PassMCQ-dnmk.onrender.com"
]


CSRF_TRUSTED_ORIGINS = [
    "https://passmcq.com",
    "https://www.passmcq.com",
    "http://127.0.0.1:8000",
    "http://localhost:8000",
]

# CSRF Settings for API compatibility
CSRF_COOKIE_HTTPONLY = False
CSRF_COOKIE_SAMESITE = 'Lax'


# Application definition

INSTALLED_APPS = [
    # Django Unfold Admin (must be before django.contrib.admin)
    'unfold',
    'unfold.contrib.filters',
    'unfold.contrib.forms',
    'unfold.contrib.import_export',

    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
    'django.contrib.humanize',
    
    # Local apps
    'app',
    'dought',
    'subscription',
    
    # Third-party apps
    'django_htmx',
    'phonenumber_field',
    'social_django',
    'django_ckeditor_5',
    'import_export',
    'django_browser_reload',
    'rest_framework',
]



CKEDITOR_5_CONFIGS = {
    'default': {
        'toolbar': ['heading', '|', 'bold', 'italic', 'underline', 'link',
                    'bulletedList', 'numberedList', 'blockQuote'],
        'language': 'en',  
    },
}

CKEDITOR_5_FILE_UPLOADER = 'django_ckeditor_5.uploader.upload'


MIDDLEWARE = [
    'django.middleware.security.SecurityMiddleware',
    'whitenoise.middleware.WhiteNoiseMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
    'django_htmx.middleware.HtmxMiddleware',
    'django_browser_reload.middleware.BrowserReloadMiddleware',
]

ROOT_URLCONF = 'passMCQ.urls'

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [BASE_DIR / 'templates'],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
                'social_django.context_processors.backends',
                'social_django.context_processors.login_redirect',
            ],
        },
    },
]

WSGI_APPLICATION = 'passMCQ.wsgi.application'


# Database
# https://docs.djangoproject.com/en/5.2/ref/settings/#databases

# DATABASES = {
#     'default': {
#         'ENGINE': 'django.db.backends.sqlite3',
#         'NAME': BASE_DIR / 'db.sqlite3',
#     }
# }



if os.environ.get("USE_MYSQL") == "true":
    DATABASES = {
        'default': {
            'ENGINE': 'django.db.backends.mysql',
            'NAME': 'passmcqc_passmcqdb',
            'USER': 'passmcqc_user',
            'PASSWORD': 'passmcqc_password',
            'HOST': 'localhost',
            'PORT': '3306',
            'OPTIONS': {
            'charset': 'utf8mb4',
            'init_command': "SET sql_mode='STRICT_TRANS_TABLES', innodb_strict_mode=1",
        },
        }
    }
else:
    DATABASES = {
        'default': {
            'ENGINE': 'django.db.backends.sqlite3',
            'NAME': BASE_DIR / 'db.sqlite3',
        }
    }





# # Email Configuration for Gmail
# EMAIL_BACKEND = 'django.core.mail.backends.smtp.EmailBackend'
# EMAIL_HOST = 'smtp.gmail.com'
# EMAIL_PORT = 587
# EMAIL_USE_TLS = True
# EMAIL_HOST_USER = 'taifkhan6789@gmail.com'  # Your Gmail address
# EMAIL_HOST_PASSWORD = 'vxrz ruwz merj mwrg'  # Your Gmail password or app password
# DEFAULT_FROM_EMAIL = 'taifkhan6789@gmail.com'  # Your Gmail address


EMAIL_BACKEND = 'django.core.mail.backends.smtp.EmailBackend'
EMAIL_HOST = 'dns3.pntdns.com'
EMAIL_PORT = 587
EMAIL_USE_TLS = True
EMAIL_USE_SSL = False
EMAIL_HOST_USER = 'sms@bd.piit.us'
EMAIL_HOST_PASSWORD = 'Sm$#ghbD854$01'
DEFAULT_FROM_EMAIL = 'sms@bd.piit.us'  # This is the "From" email shown to recipients



# Password validation
# https://docs.djangoproject.com/en/5.2/ref/settings/#auth-password-validators

AUTH_PASSWORD_VALIDATORS = []
AUTH_USER_MODEL = 'app.User'
AUTHENTICATION_BACKENDS = [
    'django.contrib.auth.backends.ModelBackend',
]


# Internationalization
# https://docs.djangoproject.com/en/5.2/topics/i18n/

LANGUAGE_CODE = 'en-us'


USE_I18N = True

USE_TZ = True
TIME_ZONE = 'Asia/Dhaka'



STATIC_URL = '/static/'
STATICFILES_DIRS = [
    BASE_DIR / "static",
]
STATIC_ROOT = os.path.join(BASE_DIR, 'staticfiles')



MEDIA_URL = '/media/'
MEDIA_ROOT = os.path.join(BASE_DIR, 'media')

# Default primary key field type
# https://docs.djangoproject.com/en/5.2/ref/settings/#default-auto-field

DEFAULT_AUTO_FIELD = 'django.db.models.BigAutoField'


# =============================================================================
# DJANGO UNFOLD ADMIN CONFIGURATION
# =============================================================================
from django.templatetags.static import static
from django.urls import reverse_lazy

UNFOLD = {
    "SITE_TITLE": "PassMCQ Admin",
    "SITE_HEADER": "PassMCQ",
    "SITE_URL": "/",
    "SITE_ICON": {
        "light": lambda request: static("img/favicon.ico"),
        "dark": lambda request: static("img/favicon.ico"),
    },
    "SITE_LOGO": {
        "light": lambda request: static("img/logo.png"),
        "dark": lambda request: static("img/logo.png"),
    },
    "SITE_SYMBOL": "school",
    "SHOW_HISTORY": True,
    "SHOW_VIEW_ON_SITE": True,
    "ENVIRONMENT": "passMCQ.settings.environment_callback",
    "DASHBOARD_CALLBACK": "passMCQ.views.dashboard_callback",
    "LOGIN": {
        "image": lambda request: static("img/auth/login.png"),
    },
    "STYLES": [
        lambda request: static("css/unfold-custom.css"),
    ],
    "COLORS": {
        "font": {
            "subtle-light": "107 114 128",
            "subtle-dark": "156 163 175",
            "default-light": "75 85 99",
            "default-dark": "209 213 219",
            "important-light": "17 24 39",
            "important-dark": "243 244 246",
        },
        "primary": {
            "50": "240 253 244",
            "100": "220 252 231",
            "200": "187 247 208",
            "300": "134 239 172",
            "400": "74 222 128",
            "500": "34 197 94",
            "600": "22 163 74",
            "700": "21 128 61",
            "800": "22 101 52",
            "900": "20 83 45",
            "950": "5 46 22",
        },
    },
    "SIDEBAR": {
        "show_search": True,
        "show_all_applications": True,
        "navigation": [
            {
                "title": "Dashboard",
                "separator": True,
                "items": [
                    {
                        "title": "Dashboard",
                        "icon": "dashboard",
                        "link": reverse_lazy("admin:index"),
                    },
                ],
            },
            {
                "title": "Users & Profiles",
                "separator": True,
                "items": [
                    {
                        "title": "Users",
                        "icon": "person",
                        "link": reverse_lazy("admin:app_user_changelist"),
                    },
                    {
                        "title": "Student Profiles",
                        "icon": "school",
                        "link": reverse_lazy("admin:app_studentprofile_changelist"),
                    },
                ],
            },
            {
                "title": "Academic Content",
                "separator": True,
                "items": [
                    {
                        "title": "Class Levels",
                        "icon": "class",
                        "link": reverse_lazy("admin:app_classlevel_changelist"),
                    },
                    {
                        "title": "Subjects",
                        "icon": "menu_book",
                        "link": reverse_lazy("admin:app_subject_changelist"),
                    },
                    {
                        "title": "Chapters",
                        "icon": "bookmark",
                        "link": reverse_lazy("admin:app_chapter_changelist"),
                    },
                ],
            },
            {
                "title": "Questions & Exams",
                "separator": True,
                "items": [
                    {
                        "title": "Questions",
                        "icon": "quiz",
                        "link": reverse_lazy("admin:app_question_changelist"),
                    },
                    {
                        "title": "Exam Categories",
                        "icon": "category",
                        "link": reverse_lazy("admin:app_examcategory_changelist"),
                    },
                    {
                        "title": "Exams",
                        "icon": "assignment",
                        "link": reverse_lazy("admin:app_exam_changelist"),
                    },
                    {
                        "title": "Exam Results",
                        "icon": "assessment",
                        "link": reverse_lazy("admin:app_examresult_changelist"),
                    },
                ],
            },
            {
                "title": "Subscriptions",
                "separator": True,
                "items": [
                    {
                        "title": "Bundle Subscriptions",
                        "icon": "inventory_2",
                        "link": reverse_lazy("admin:subscription_bundlesubscription_changelist"),
                    },
                    {
                        "title": "Annual Subscriptions",
                        "icon": "calendar_month",
                        "link": reverse_lazy("admin:subscription_annualsubscription_changelist"),
                    },
                    {
                        "title": "Subject Subscriptions",
                        "icon": "subject",
                        "link": reverse_lazy("admin:subscription_subjectbasedsubscription_changelist"),
                    },
                ],
            },
        ],
    },
}


def environment_callback(request):
    """Return the environment name for display in admin."""
    if DEBUG:
        return ["Development", "warning"]
    return ["Production", "success"]


# =============================================================================
# DJANGO REST FRAMEWORK CONFIGURATION
# =============================================================================
REST_FRAMEWORK = {
    'DEFAULT_AUTHENTICATION_CLASSES': [
        'rest_framework.authentication.SessionAuthentication',
        'rest_framework.authentication.BasicAuthentication',
    ],
    'DEFAULT_PERMISSION_CLASSES': [
        'rest_framework.permissions.IsAuthenticated',
    ],
    'DEFAULT_RENDERER_CLASSES': [
        'rest_framework.renderers.JSONRenderer',
        'rest_framework.renderers.BrowsableAPIRenderer',
    ],
    'DEFAULT_PAGINATION_CLASS': 'rest_framework.pagination.PageNumberPagination',
    'PAGE_SIZE': 20,
}


# =============================================================================
# CACHING CONFIGURATION
# =============================================================================
if os.environ.get('REDIS_URL'):
    CACHES = {
        'default': {
            'BACKEND': 'django_redis.cache.RedisCache',
            'LOCATION': os.environ.get('REDIS_URL', 'redis://127.0.0.1:6379/1'),
            'OPTIONS': {
                'CLIENT_CLASS': 'django_redis.client.DefaultClient',
            }
        }
    }
else:
    CACHES = {
        'default': {
            'BACKEND': 'django.core.cache.backends.locmem.LocMemCache',
            'LOCATION': 'unique-snowflake',
        }
    }

# Session cache
SESSION_ENGINE = 'django.contrib.sessions.backends.cached_db'


# =============================================================================
# WHITENOISE STATIC FILE CONFIGURATION
# =============================================================================
STATICFILES_STORAGE = 'whitenoise.storage.CompressedManifestStaticFilesStorage'


# =============================================================================
# SECURITY SETTINGS (for production)
# =============================================================================
if not DEBUG:
    SECURE_BROWSER_XSS_FILTER = True
    SECURE_CONTENT_TYPE_NOSNIFF = True
    X_FRAME_OPTIONS = 'DENY'
    SECURE_SSL_REDIRECT = True
    SESSION_COOKIE_SECURE = True
    CSRF_COOKIE_SECURE = True
    SECURE_HSTS_SECONDS = 31536000
    SECURE_HSTS_INCLUDE_SUBDOMAINS = True
    SECURE_HSTS_PRELOAD = True


AUTHENTICATION_BACKENDS = (
    'social_core.backends.google.GoogleOAuth2',
    # 'social_core.backends.facebook.FacebookOAuth2',
    'django.contrib.auth.backends.ModelBackend',
)



# # Facebook OAuth2 settings
# SOCIAL_AUTH_FACEBOOK_KEY = 'your-facebook-app-id'
# SOCIAL_AUTH_FACEBOOK_SECRET = 'your-facebook-app-secret'
# SOCIAL_AUTH_FACEBOOK_SCOPE = ['email']
# SOCIAL_AUTH_FACEBOOK_PROFILE_EXTRA_PARAMS = {
#     'fields': 'id, name, email'
# }


# Google OAuth2 settings
SOCIAL_AUTH_GOOGLE_OAUTH2_KEY = '1052982796911-29vvd8k1rqfen00r55ccvter80lrem4a.apps.googleusercontent.com'
SOCIAL_AUTH_GOOGLE_OAUTH2_SECRET = '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'


LOGIN_URL = 'login'
LOGIN_REDIRECT_URL = ''
LOGOUT_REDIRECT_URL = ''
SOCIAL_AUTH_LOGIN_REDIRECT_URL = ''
SOCIAL_AUTH_GOOGLE_OAUTH2_REDIRECT_URI = 'https://PassMCQ-dnmk.onrender.com/social-auth/complete/google-oauth2/'



SOCIAL_AUTH_PIPELINE = (
    'social_core.pipeline.social_auth.social_details',
    'social_core.pipeline.social_auth.social_uid',
    'social_core.pipeline.social_auth.auth_allowed',
    'social_core.pipeline.social_auth.social_user',
    'social_core.pipeline.user.get_username',
    'social_core.pipeline.user.create_user',
    'app.pipeline.create_student_profile',  # Add this line
    'social_core.pipeline.social_auth.associate_user',
    'social_core.pipeline.social_auth.load_extra_data',
    'social_core.pipeline.user.user_details',
)