# Generated by Django 5.2.1 on 2026-01-28 10:24

import django.db.models.deletion
import uuid
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('app', '0001_initial'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Bookmark',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='user_bookmarks', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'doubts_bookmark',
            },
        ),
        migrations.CreateModel(
            name='Doubt',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('post_type', models.CharField(choices=[('text', 'Text Post'), ('image', 'Image Post'), ('document', 'Document Post'), ('link', 'Link Post')], max_length=10)),
                ('title', models.CharField(max_length=200)),
                ('content', models.TextField(blank=True, null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('bookmarks', models.ManyToManyField(blank=True, related_name='bookmarked_doubts', through='dought.Bookmark', to=settings.AUTH_USER_MODEL)),
                ('chapter', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='app.chapter')),
                ('class_level', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='app.classlevel')),
                ('likes', models.ManyToManyField(blank=True, related_name='liked_doubts', to=settings.AUTH_USER_MODEL)),
                ('subject', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='app.subject')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='doubts', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'doubts_doubt',
                'ordering': ['-created_at'],
            },
        ),
        migrations.CreateModel(
            name='Comment',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('content', models.TextField()),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('doubt', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='comments', to='dought.doubt')),
            ],
            options={
                'db_table': 'doubts_comment',
                'ordering': ['created_at'],
            },
        ),
        migrations.AddField(
            model_name='bookmark',
            name='doubt',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='doubt_bookmarks', to='dought.doubt'),
        ),
        migrations.CreateModel(
            name='DoubtDocument',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('document', models.FileField(upload_to='doubts/documents/')),
                ('description', models.CharField(blank=True, max_length=200, null=True)),
                ('doubt', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='documents', to='dought.doubt')),
            ],
            options={
                'db_table': 'doubts_doubtdocument',
            },
        ),
        migrations.CreateModel(
            name='DoubtImage',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('image', models.ImageField(upload_to='doubts/images/')),
                ('caption', models.CharField(blank=True, max_length=200, null=True)),
                ('doubt', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='images', to='dought.doubt')),
            ],
            options={
                'db_table': 'doubts_doubtimage',
            },
        ),
        migrations.CreateModel(
            name='DoubtLink',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('url', models.URLField()),
                ('description', models.CharField(blank=True, max_length=200, null=True)),
                ('doubt', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='links', to='dought.doubt')),
            ],
            options={
                'db_table': 'doubts_doubtlink',
            },
        ),
        migrations.CreateModel(
            name='Notification',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('is_read', models.BooleanField(default=False)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('comment', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='dought.comment')),
                ('doubt', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='dought.doubt')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='notifications', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'doubts_notification',
                'ordering': ['-created_at'],
            },
        ),
        migrations.AlterUniqueTogether(
            name='bookmark',
            unique_together={('user', 'doubt')},
        ),
    ]
