from django.contrib import admin
from .models import Doubt, DoubtImage, DoubtDocument, DoubtLink, Comment

class DoubtImageInline(admin.TabularInline):
    model = DoubtImage
    extra = 1

class DoubtDocumentInline(admin.TabularInline):
    model = DoubtDocument
    extra = 1

class DoubtLinkInline(admin.TabularInline):
    model = DoubtLink
    extra = 1

class CommentInline(admin.TabularInline):
    model = Comment
    extra = 1

@admin.register(Doubt)
class DoubtAdmin(admin.ModelAdmin):
    list_display = ('title', 'user', 'post_type', 'class_level', 'subject', 'created_at')
    list_filter = ('post_type', 'class_level', 'subject')
    search_fields = ('title', 'content', 'user__username')
    inlines = [DoubtImageInline, DoubtDocumentInline, DoubtLinkInline, CommentInline]

@admin.register(Comment)
class CommentAdmin(admin.ModelAdmin):
    list_display = ('user', 'doubt', 'created_at')
    search_fields = ('content', 'user__username', 'doubt__title')