from django import forms
from django.forms import modelformset_factory, inlineformset_factory
from .models import Question, Choice

class QuestionForm(forms.ModelForm):
    class Meta:
        model = Question
        fields = ['text', 'question_type', 'subject', 'chapter', 'exam_category', 'difficulty']

# Formset for multiple questions
QuestionFormSet = modelformset_factory(Question, form=QuestionForm, extra=3)

# Choice form (not a formset yet)
class ChoiceForm(forms.ModelForm):
    class Meta:
        model = Choice
        fields = ['text', 'is_correct']
